<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('releases', function (Blueprint $table) {
            $table->id();
            $table->string('lang')->nullable();
            $table->string('artists')->nullable();
            $table->string('display_artist')->nullable();
            $table->string('feature_artist')->nullable();
            $table->string('remixer')->nullable();
            $table->string('composer')->nullable();
            $table->string('orchestra')->nullable();
            $table->string('arranger')->nullable();
            $table->string('actor')->nullable();
            $table->string('conductor')->nullable();
            $table->boolean('is_instrumental')->default(false);
            $table->string('lyricist_firstname')->nullable();
            $table->string('lyricist_lastname')->nullable();
            $table->string('title')->nullable();
            $table->string('label_id')->nullable();
            $table->text('artwork')->nullable();
            $table->text('apple_art')->nullable();
            $table->string('release_type')->nullable();
            $table->string('cat_number')->nullable();
            $table->integer('genre_id')->nullable();
            $table->integer('subgenre_id')->nullable();
            $table->boolean('is_upc')->default(false);
            $table->dateTime('release_date')->nullable();
            $table->string('p_line')->nullable();
            $table->string('c_line')->nullable();
            $table->string('copyrights')->nullable();
            $table->string('price_tier')->nullable();
            $table->string('parental_warning_type')->nullable();
            $table->longText('description')->nullable();
            $table->longText('country_ids')->nullable();
            $table->longText('dsp_ids')->nullable();
            $table->string('exclusive_on_shop')->nullable();
            $table->string('exclusive_for')->nullable();
            $table->boolean('on_itunes')->default(false);
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('releases');
    }
};
